package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.enumeration.UserStatusEnum;
import gov.va.med.mhv.sm.enumeration.PerformerTypeEnum;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.UserManagementService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;

public class UserParticipation extends BaseSMAdminAction implements Preparable {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(UserParticipation.class);

	private static final String CANCEL = "cancel";
	private static final String FAILED = "failed";
	private UserManagementService userManagementService;
	//private List<Facility> visns;
	//private List<Facility> facilities;
	private Collection<Facility> facilities;
	private Long selectedVisn;
	private Long selectedFacility;
	private String selectedVisnName;
	private String selectedFacilityName;
	private List<Clinician> clinicians;
	private List<Clinician> selectedUsers;
	private HttpServletRequest request;
	private List<String> availableMembers;
	private List<String> selectedMembers;
	private String selectAction;
	private String optIn;

	public UserParticipation() {
		super();
	}

	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
	}


	public String userParticipationStatus() {
		removeSessionAttr();
		//visns =	(List<Facility>)getFacilityService().getVisnList().getCollection();
		return SUCCESS;
	}


	public String selectFacilitiesInVisn() {

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			removeSessionAttr();
			return CANCEL;
		}
		//visns =	(List<Facility>)getFacilityService().getVisnList().getCollection();
		if((selectedVisn == null) || (selectedVisn == -1)){
			selectedVisn = null;
			addActionError("Please select a VISN.");
			return SUCCESS;
		}else{
			log.info("Selected Visn:" + selectedVisn);
		}
		facilities = new TreeSet<Facility>();
		for(Facility v : getAdministeredVisns()){
			if(v.getId().equals(selectedVisn)){
				selectedVisnName = v.getName();
				facilities = getAdministeredFacilitiesInVisn(v);
			}
		}
		setSessionAttribute("selectedVisn",selectedVisn);
		setSessionAttribute("selectedVisnName",selectedVisnName);
		setSessionAttribute("facilities",facilities);
		return SUCCESS;
	}

	public String selectCliniciansInFacility() {

	    // Defect 5530 - removes the selected users from the session
		if(((List<Clinician>)getSessionAttribute("selectedUsers")) != null){
			removeSelectedUsers();
			//selectedUsers = (List<Clinician>)getSessionAttribute("selectedUsers");
		}		
		
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			removeSessionAttr();
			return CANCEL;
		}
		//visns =	(List<Facility>)getFacilityService().getVisnList().getCollection();
		selectedVisn = (Long)getSessionAttribute("selectedVisn");
		facilities = (Collection<Facility>)getSessionAttribute("facilities");
		if((selectedFacility == null) || (selectedFacility == -1)){
			addActionError("Please select a Facility.");
			return FAILED;
		}else{
			log.info("Selected Facility:" + selectedFacility);
		}

		Facility selectFacility = null;

		for(Facility f : facilities){
			if(f.getId().equals(selectedFacility)){
				selectedFacilityName = f.getName();
				selectFacility = f;
				break;
			}
		}
		if(selectFacility != null){
			log.info("selectFacility.getStationNumber():" + selectFacility.getStationNumber().toString());
			clinicians = (List<Clinician>) userManagementService.getCliniciansForStationAll(selectFacility.getStationNumber()).getCollection();
			//clinicians = (List<Clinician>) userManagementService.getCliniciansForStationAll("648").getCollection();
		}
		setSessionAttribute("clinicians",clinicians);
		return SUCCESS;
	}


	public String groupOptIn() {

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Cancel"))){
			removeSessionAttr();
			return CANCEL;
		}

		clinicians = (List<Clinician>)getSessionAttribute("clinicians");
		selectedUsers = new ArrayList<Clinician>();
		if(((List<Clinician>)getSessionAttribute("selectedUsers")) != null){
			selectedUsers = (List<Clinician>)getSessionAttribute("selectedUsers");
		}

		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Add ->"))){

			if (clinicians != null){
			  	for(Clinician c: clinicians){
					String cId = String.valueOf(c.getId());
					if( availableMembers != null){
						Iterator iterator = availableMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {
								if(((String)iterator.next()).equals(cId)){
									selectedUsers.add(c);
								}
							}
						}
					}
			  	}
			}

			setSessionAttribute("selectedUsers", selectedUsers);

		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("<- Remove"))){
			List<Clinician> tempUsers = new ArrayList<Clinician>();
			if (selectedUsers != null){
			  	for(Clinician c: selectedUsers){
					String cId = String.valueOf(c.getId());
					if( selectedMembers != null){
						Iterator iterator = selectedMembers.iterator();
						if (iterator != null){
							while (iterator.hasNext()) {															;
								if(((String)iterator.next()).equals(cId)){
									tempUsers.add(c);
								}
							}
						}
					}
			  	}
			}
			if (tempUsers != null){
			  	for(Clinician c: tempUsers){
					selectedUsers.remove(c);
			  	}
			}

			setSessionAttribute("selectedUsers", selectedUsers);

		}
		if((selectAction!=null) && (selectAction.equalsIgnoreCase("Save Status"))){
			Long optInStatusNum;
			try {
				optInStatusNum = Long.valueOf(optIn);
			} catch (Exception e) {
				log.error("Error occurred while setting Opt-in value.");
				return SUCCESS;
			}
			if (selectedUsers != null){
				for(Clinician c: selectedUsers){
					User user = c;
					if(UserStatusEnum.valueOf(optInStatusNum) == UserStatusEnum.OPT_OUT){
						setSessionAttribute("OPTSTATUS","OPTOUT");
						userManagementService.optOutUser(user,PerformerTypeEnum.ADMINISTRATOR);		// added to set the correct PERFORMER_TYPE(CQ: 5374)
					}else if(UserStatusEnum.valueOf(optInStatusNum) == UserStatusEnum.OPT_IN){
						setSessionAttribute("OPTSTATUS","OPTIN");
						userManagementService.optInUser(user,PerformerTypeEnum.ADMINISTRATOR);		// added to set the correct PERFORMER_TYPE(CQ: 5374)
					}
				}
			}
		}
		return SUCCESS;
	}


	public void removeSessionAttr(){
		removeSessionAttribute("facilities");
		removeSessionAttribute("selectedUsers");
		removeSessionAttribute("selectedVisn");
	}

	public void removeSelectedUsers(){
		removeSessionAttribute("selectedUsers");
	}	

/*	public void setVisns(List<Facility> visns) {
			this.visns = visns;
	}

	public List<Facility> getVisns() {
			return visns;
	}*/

	public void setSelectedVisnName(String selectedVisnName) {
			this.selectedVisnName = selectedVisnName;
	}

	public String getSelectedVisnName() {
			return selectedVisnName;
	}

	public void setSelectedFacilityName(String selectedFacilityName) {
			this.selectedFacilityName = selectedFacilityName;
	}

	public String getSelectedFacilityName() {
			return selectedFacilityName;
	}

	public void setFacilities(Collection<Facility> facilities) {
			this.facilities = facilities;
	}

	public Collection<Facility> getFacilities() {
			return facilities;
	}


	public void setSelectedVisn(Long selectedVisn) {
			this.selectedVisn = selectedVisn;
	}

	public Long getSelectedVisn() {
			return selectedVisn;
	}

	public void setSelectedFacility(Long selectedFacility) {
			this.selectedFacility = selectedFacility;
	}

	public Long getSelectedFacility() {
			return selectedFacility;
	}

	public void setClinicians(List<Clinician> clinicians) {
			this.clinicians = clinicians;
	}

	public List<Clinician> getClinicians() {
			return clinicians;
	}

	public void setAvailableMembers(List<String> availableMembers) {
		this.availableMembers = availableMembers;
	}

	public List<String> getAvailableMembers() {
		return availableMembers;
	}

	public void setSelectedMembers(List<String> selectedMembers) {
		this.selectedMembers = selectedMembers;
	}

	public List<String> getSelectedMembers() {
		return selectedMembers;
	}

	public void setSelectAction(String selectAction) {
		this.selectAction = selectAction;
	}

	public String getSelectAction() {
		return selectAction;
	}

	public void setSelectedUsers(List<Clinician> selectedUsers) {
			this.selectedUsers = selectedUsers;
	}

	public List<Clinician> getSelectedUsers() {
			return selectedUsers;
	}

	public void setOptIn(String optIn) {
			this.optIn = optIn;
	}

	public String getOptIn() {
			return optIn;
	}
}
